<?php declare(strict_types = 1);

namespace Core\Model\Dao;

class SiteDomain
{
	/** @var string */
	protected $domain;

	/** @var string */
	public $siteName;

	/** @var string */
	public $siteNameSeparator;

	/** @var string */
	protected $lang;

	/** @var int */
	public $isDefault = 0;

	public function __construct(Site $site, string $domain, string $lang, int $isDefault = 0)
	{
		$this->domain    = $domain;
		$this->lang      = $lang;
		$this->isDefault = $isDefault;
		$site->addDomain($this, $isDefault);
	}

	public function getDomain(): string { return $this->domain; }

	public function getLang(): string { return $this->lang; }
}
