<?php declare(strict_types = 1);

namespace Core\Model\Helpers;

use Core\Model\Entities\ExtraField;
use Nette\Utils\DateTime;

abstract class EntityHelpers
{
	public static function validateDate($date)
	{
		if ($date != null && $date != '' && !($date instanceof DateTime))
			throw new \InvalidArgumentException();

		if ($date == '')
			$date = null;

		return $date;
	}

	public static function setExtraField($entity, $key, $value, ?string $lang = null): ExtraField
	{
		$ef = $entity->getExtraFieldsByKey();

		$result = $ef[$key] ?? null;

		if ($lang)
			$result = $result[$lang] ?? null;

		if (!$result) {
			$result       = new ExtraField($key, $value);
			$result->lang = $lang;
			$entity->fillExtraField($result);
		}

		$result->value = $value;

		return $result;
	}
}
