<?php declare(strict_types = 1);

namespace Core\Model\Mailing;

use Nette\Application\LinkGenerator;
use Nette\Application\UI\ITemplateFactory;
use Nette\Bridges\ApplicationLatte\Template;

class TemplateFactory extends AbstractTemplateFactory
{
	/** @var ITemplateFactory */
	protected $templateFactory;

	/** @var LinkGenerator */
	protected $linkGenerator;

	/**
	 * @param ITemplateFactory $templateFactory
	 * @param LinkGenerator    $linkGenerator
	 */
	public function __construct(ITemplateFactory $templateFactory, LinkGenerator $linkGenerator)
	{
		$this->templateFactory = $templateFactory;
		$this->linkGenerator   = $linkGenerator;

		$this->setConfig($this->config);
		$this->setDefaults($this->defaults);
	}

	/**
	 * API *********************************************************************
	 */

	/**
	 * @return Template
	 */
	public function create()
	{
		/** @var Template $template */
		$template = $this->templateFactory->createTemplate();

		// For macros {link} {plink}
		$template->getLatte()->addProvider('uiControl', $this->linkGenerator);

		// Prepare template
		$template = $this->prepare($template);

		return $template;
	}

}
