<?php declare(strict_types = 1);

namespace Core\Model\Templating\Filters;

use Core\Model\Helpers\Strings;

class Phone
{
	public function __construct()
	{
	}

	/**
	 * @param string      $phone
	 * @param string|null $region
	 * @param bool        $showRegion
	 *
	 * @return string
	 */
	public function __invoke(string $phone, ?string $region = null, bool $showRegion = false): string
	{
		return Strings::phoneFormat($phone, $region, $showRegion);
	}
}
