<?php declare(strict_types = 1);

namespace Core\Model\UI\DataGrid\Column;

use Nette\Utils\Html;
use Ublaboo;
use Ublaboo\DataGrid\Column\Action\Confirmation\StringConfirmation;
use Ublaboo\DataGrid\DataGrid;
use Ublaboo\DataGrid\Row;

class Action extends Ublaboo\DataGrid\Column\Action
{
	protected $class  = 'btn btn-xs';
	protected $bsType = 'secondary';

	public function render(Row $row)
	{
		$html = parent::render($row);

		if ($html instanceof Html)
			$html->class .= ' btn-' . $this->bsType;

		return $html;
	}

	public function addClass($class)
	{
		$this->class .= ' ' . $class;

		return $this;
	}

	/*******************************************************************************************************************
	 * ==========================  Setters
	 */
	public function setBsType($type = 'secondary')
	{
		$this->bsType = $type;

		return $this;
	}

	public function setConfirm($val): self
	{
		$confirm = null;
		if (is_string($val))
			$confirm = new StringConfirmation($val);

		if (is_callable($val))
			$confirm = new Ublaboo\DataGrid\Column\Action\Confirmation\CallbackConfirmation($val);

		if ($confirm)
			$this->setConfirmation($confirm);

		return $this;
	}

	protected function createLink(DataGrid $grid, string $href, array $params): string
	{
		try {
			$link = parent::createLink($grid, $href, $params);
		} catch (\Exception $e) {
			$link = $this->grid->getPresenter()->link($href, $params);
		}

		return $link;
	}

}
