<?php declare(strict_types = 1);

namespace Core\Model\UI\DataGrid\Column;

use Core\Model\UI\DataGrid\Status\Option;
use Ublaboo;
use Ublaboo\DataGrid\DataGrid;
use Ublaboo\DataGrid\Exception\DataGridColumnStatusException;

class ColumnStatus extends Ublaboo\DataGrid\Column\ColumnStatus
{
	public function __construct(DataGrid $grid, string $key, string $column, string $name)
	{
		parent::__construct($grid, $key, $column, $name);
		$this->setTemplate(__DIR__ . '/../templates/column_status.latte');
	}

	/**
	 * Add option to status select
	 *
	 * @param mixed  $value
	 * @param string $text
	 *
	 * @return Option
	 * @throws DataGridColumnStatusException
	 */
	public function addOption($value, $text): Ublaboo\DataGrid\Status\Option
	{
		if (!is_scalar($value)) {
			throw new DataGridColumnStatusException('Option value has to be scalar');
		}

		$option = new Option($this, $value, $text);

		$this->options[] = $option;

		return $option;
	}
}
