<?php declare(strict_types = 1);

namespace Core\Model\UI\Form\Controls;

use Core\Model\Helpers\Strings;
use Core\Model\UI\Form\Traits\TInputExtend;
use Nette\Forms\Controls\Checkbox;
use Nette\Utils\Html;


class CheckboxInput extends Checkbox
{
	use TInputExtend;

	/**
	 * Generates a checkbox
	 * @return Html
	 */
	public function getControl(): Html
	{
		parent::getControl();

		$caption = $this->translate($this->caption);

		return self::makeCheckbox($this->getHtmlName(), $caption, $this->value, false, $this->required,
			$this->disabled, $this->getHtmlId());
	}

	public function getLabel($caption = null): void
	{
	}

	/**
	 * Makes a Bootstrap checkbox
	 *
	 * @param string      $name
	 * @param string|null $caption
	 * @param bool        $checked
	 * @param bool|mixed  $value pass false to omit
	 * @param bool        $required
	 * @param bool        $disabled
	 *
	 * @return Html
	 */
	public static function makeCheckbox($name, $caption = null, $checked = false, $value = false, $required = false, $disabled = false, $htmlId)
	{
		$wrap  = Html::el('div', ['class' => 'pretty p-check']);
		$label = Html::el('label', ['for' => $htmlId])
			->setText($caption);
		$input = Html::el('input', [
			'type'     => 'checkbox',
			'class'    => 'form-check-input',
			'name'     => $name,
			'disabled' => $disabled,
			'required' => $required,
			'checked'  => $checked,
			'id'       => $htmlId,
		]);

		if ($value !== false) {
			$input->attrs += [
				'value' => $value,
			];
		}

		$wrap->addHtml($input)
			->addHtml(
				Html::el('div class=state')
					->addHtml(Html::el('i class="icon fas fa-check"'))
					->addHtml($label)
			);

		return $wrap;

		$label->addHtml($input);
		$label->addText($caption);

		$line = Html::el('div', [
			'class' => 'form-check' . ($disabled ? ' disabled' : ''),
		]);
		$line->setHtml($label);

		return $line;
	}
}
