<?php declare(strict_types = 1);

namespace Core\Model\UI\Form\Controls;

use Core\Model\UI\Form\Traits\ChoiceInputTrait;
use Core\Model\UI\Form\Traits\TInputExtend;
use Nette\Forms\Controls\RadioList;
use Nette\Forms\Helpers;
use Nette\Utils\Html;
use Nette\Utils\Strings;


/**
 * Class RadioList
 * @package Czubehead\BootstrapForms
 */
class RadioInput extends RadioList
{
	use ChoiceInputTrait;
	use TInputExtend;

	/**
	 * @var Html
	 */
	protected $container;

	/**
	 * @param string|object
	 * @param array|null $items
	 */
	public function __construct($label = null, array $items = null)
	{
		parent::__construct($label, $items);
		$this->control->type = 'radio';
		$this->container     = Html::el();
		$this->setOption('type', 'radio');
	}

	/**
	 * Generates control's HTML element.
	 * @return Html
	 */
	public function getControl(): Html
	{
		// has to run
		parent::getControl();

		$items     = $this->getItems();
		$container = $this->container;

		foreach ($items as $value => $caption) {
			$disabledOption = $this->isValueDisabled($value);

			$wrapper = Html::el('div', [
				'class' => 'form-check' . ($disabledOption ? ' disabled' : ''),
			]);
			$inputId = $this->getHtmlId() . '_' . Strings::webalize((string) $value);

			$label = Html::el('label', [
				'class' => 'form-check-label',
				'for'   => $inputId,
			]);
			$input = Html::el('input', [
				'class'            => 'form-check-input',
				'type'             => 'radio',
				'value'            => $value,
				'name'             => $this->getHtmlName(),
				'checked'          => $this->isValueSelected($value),
				'disabled'         => $disabledOption,
				'id'               => $inputId,
				'data-nette-rules' => Helpers::exportRules($this->getRules()) ?: null,
			]);

			$wrapper->addHtml($input);
			$label->addText($caption);
			$wrapper->addHtml($label);

			$container->addHtml($wrapper);
		}

		return $container;
	}
}
