<?php declare(strict_types = 1);

namespace Core\Model\UI\Form\Traits;

use Nette\Utils\Html;
use Nette;

/**
 * Trait TTextBase
 * @package Core\Model\UI\Form\Traits
 */
trait TTextBase
{
	public function getControl(): Html
	{
		$control = parent::getControl();
		$control->addClass('form-control form-control-lg');
		if (!empty($this->placeholder)) {
			$control->setAttribute('placeholder', $this->placeholder);
		}

		return $this->createTranslatableControl($control);
	}

	protected function getRenderedValue(): ?string
	{
		$rawValue = is_array($this->rawValue) ? array_values($this->rawValue)[0] : $this->rawValue;

		return $rawValue === ''
			? ($this->emptyValue === '' ? null : $this->translate($this->emptyValue))
			: $rawValue;
	}

	/**
	 * Sets control's value.
	 * @return static
	 * @internal
	 */
	public function setValue($value)
	{
		if ($value === null) {
			$value = '';
		} elseif (!$this->getIsMultiLanguage() && !is_scalar($value) && !method_exists($value, '__toString')) {
			if (is_array($value))
				$value = array_values($value)[0];
			else
				throw new Nette\InvalidArgumentException(sprintf("Value must be scalar or null, %s given in field '%s'.", gettype($value), $this->name));
		}
		$this->value    = $value;
		$this->rawValue = $this->getIsMultiLanguage() ? (array) $value : (string) $value;

		return $this;
	}
}
