import flatpickr from "flatpickr";
import {Czech} from "flatpickr/dist/l10n/cs.js";
import monthSelectPlugin from "flatpickr/dist/plugins/monthSelect/index";
import Choices from "choices.js";

const showTtLinkTypeFrmPair = (selectEl) => {
	let fieldset = selectEl.closest('fieldset');

	fieldset.querySelectorAll('[name*="component[' + selectEl.dataset.ttLinkSelect + '][types]"]').forEach(inputEl => {
		let wrap = inputEl.closest('.frm__pair');

		if (inputEl.name.indexOf('component[' + selectEl.dataset.ttLinkSelect + '][types][' + selectEl.value + ']') === 0) {
			wrap.style.display = 'block';
		} else {
			wrap.style.display = 'none';
		}
	})
}

const initShowTtLinkTypeFrmPair = () => {
	document.querySelectorAll('[data-tt-link-select]').forEach(selectEl => {
		showTtLinkTypeFrmPair(selectEl);
	})
}

document.addEventListener('DOMContentLoaded', () => {
	initShowTtLinkTypeFrmPair();
});

document.addEventListener('change', e => {
	const target = e.target;

	if (target.dataset.ttLinkSelect !== undefined) {
		showTtLinkTypeFrmPair(target);
	}
})

const choicesAddCallback = (choicesElement) => {
	choicesElement.input.element.addEventListener('keydown', (keypressEvent) => {
		if (keypressEvent.keyCode === 13 && keypressEvent.target.value) {
			let keywordHits = 0;
			[...choicesElement.choiceList.element.children].forEach((element) => {
				if (element.innerText.includes(keypressEvent.target.value)) {
					keywordHits += 1;
				}
			});
			if (!keywordHits) {
				keypressEvent.stopPropagation();
				const linterEvent = keypressEvent;
				global.naja.makeRequest('post', choicesElement.passedElement.element.dataset.addCallback, {
					'value': linterEvent.target.value
				}, {history: false}).then(response => {
					if (response.status === 'ok' && response.data) {
						choicesElement.setChoices([
							{
								value   : response.data.id,
								label   : response.data.name,
								selected: true,
							},
						], 'value', 'label', false);
					}

					linterEvent.target.value = '';
				});
			}
		}
	});
};

const initDatePickers = () => {
	document.querySelectorAll('.datetimepicker, .datepicker, [data-provide="datepicker"]').forEach(el => {
		const parentElement = el.parentElement;

		if (!el.closest('.flatpicker-wrap')) {
			let clearA = document.createElement('a');
			clearA.setAttribute('class', 'btn btn-xs btn-danger');
			clearA.setAttribute('href', 'javascript:;');
			clearA.setAttribute('data-clear', '');
			clearA.innerHTML = '<i class="fas fa-times"></i>';

			try {
				parentElement.classList.add('flatpicker-wrap');
				parentElement.insertBefore(clearA, parentElement.nextElementSibling);
				el.parentElement.appendChild(clearA);
			} catch (e) {
			}
		}

		el.addEventListener('click', e => {
			if (el.inited === true) {
				return;
			}

			let isDate     = el.classList.contains('datepicker') || el.type === 'date';
			let dateFormat = 'd. m. Y';
			let enableDate = !isDate;

			if (!isDate) {
				dateFormat = 'd. m. Y - H:i';
				enableDate = true;
			}

			if (el.dataset.provide === 'datepicker') {
				dateFormat = 'd. m. Y';
				enableDate = false;
			}

			let options = {
				locale     : Czech,
				minDate    : el.dataset.min,
				maxDate    : el.dataset.max,
				time_24hr  : true,
				dateFormat : dateFormat,
				enableTime : enableDate,
				defaultDate: el.getAttribute('value'),
			}

			if (el.dataset.monthSelect === 'true') {
				options.plugins = [
					new monthSelectPlugin({
						shorthand : false,
						dateFormat: "Y-m",
						altFormat : "T-m",
						theme     : "blue"
					})
				];
			}

			flatpickr(el, options);

			if (el.inited !== true) {
				el.inited = true;

				el._flatpickr.open();
			}

			el.inited = true;
		});

		let wrap = el.closest('.flatpicker-wrap');
		if (wrap) {
			let clearEl = wrap.querySelector('a');

			if (clearEl) {
				clearEl.addEventListener('click', e => {
					if (el.inited === true)
						el._flatpickr.clear();
					else
						el.value = '';
				});
			}
		}
	})
}
const initTimePickers = () => {
	document.querySelectorAll('.timepicker').forEach(el => {
		el.addEventListener('click', e => {
			if (el.inited === true)
				return;

			let options = {
				locale     : Czech,
				minTime    : el.dataset.min,
				maxTime    : el.dataset.max,
				time_24hr  : true,
				dateFormat : 'H:i',
				enableTime : true,
				noCalendar : true,
				defaultDate: el.getAttribute('value'),
			}

			flatpickr(el, options);

			if (el.inited !== true) {
				el.inited = true;

				el._flatpickr.open();
			}

			el.inited = true;
		});

		let wrap = el.closest('.flatpicker-wrap');
		if (wrap) {
			let clearEl = wrap.querySelector('a');

			clearEl.addEventListener('click', e => {
				el._flatpickr.clear();
			});
		}
	})
}

const initSelectOne = () => {
	document.querySelectorAll('.nested-list').forEach(group => {
		let items = group.querySelectorAll('.nested-list__item');
		items.forEach(el => {
			let span = el.querySelector('.select-one');

			if (span) {
				span.addEventListener('click', e => {
					e.stopImmediatePropagation();

					group.querySelectorAll('.nested-list__item input:checked').forEach(input => {
						input.removeAttribute('checked');
						input.checked = false;
					});

					let input = span.nextElementSibling;

					input.checked = true;
					input.dispatchEvent(new Event('change'));

					return false;
				})
			}
		});
	});
}

let choicesIndex   = 0;
global.choicesList = global.choicesList || {};
const initChoices  = () => {
	document.querySelectorAll(
		'.frm__type-select select:not([data-choice]), ' +
		'select.select--choice:not([data-choice]), ' +
		'.col-filters select:not([data-choice])'
	).forEach(select => {
		if (select.style.display === 'none')
			return true;

		let threshold = select.dataset.threshold || .3;

		let config = {
			loadingText      : '',
			noResultsText    : '',
			noChoicesText    : '',
			itemSelectText   : '',
			shouldSort       : false,
			shouldSortItems  : false,
			searchResultLimit: 15,
			fuseOptions      : {
				isCaseSensitive   : false,
				threshold         : threshold,
				distance          : 200,
				ignoreLocation    : true,
				includeScore      : true,
				minMatchCharLength: 2,
			},
		};

		if (select.dataset.addCallback !== undefined) {
			config.fuseOptions.threshold = 0;
		}

		global.choicesList[choicesIndex] = new Choices(select, config);

		if (select.dataset.addCallback !== undefined) {
			choicesAddCallback(global.choicesList[choicesIndex]);
		}

		select.setAttribute('data-choices-index', choicesIndex);
		let choices = global.choicesList[choicesIndex];

		if (select.getAttribute('data-confirm')) {
			choices._handleChoiceAction = (activeItems, element) => {
				if (!activeItems || !element) {
					return;
				}

				const {id}   = element.dataset;
				const choice = choices._store.getChoiceById(id);
				if (!choice) {
					return;
				}

				if (choices.getValue().value) {
					let r = confirm(select.getAttribute('data-confirm'));
					if (r !== true) {
						return
					}
				}

				const passedKeyCode     =
					      activeItems[0] && activeItems[0].keyCode ? activeItems[0].keyCode : null;
				const hasActiveDropdown = choices.dropdown.isActive;

				choice.keyCode = passedKeyCode;

				choices.passedElement.triggerEvent('choice', {
					choice,
				});

				if (!choice.selected && !choice.disabled) {
					const canAddItem = choices._canAddItem(activeItems, choice.value);

					if (canAddItem.response) {
						choices._addItem({
							value           : choice.value,
							label           : choice.label,
							choiceId        : choice.id,
							groupId         : choice.groupId,
							customProperties: choice.customProperties,
							placeholder     : choice.placeholder,
							keyCode         : choice.keyCode,
						});

						choices._triggerChange(choice.value);
					}
				}

				choices.clearInput();

				if (hasActiveDropdown && choices._isSelectOneElement) {
					choices.hideDropdown(true);
					choices.containerOuter.focus();
				}
			}
		}

		choicesIndex++;
	});
}

initDatePickers();
initTimePickers();
initSelectOne();
initChoices();

// Kvůli kompatibilitě s jquery
window.jQuery(document).ajaxComplete(function (event, xhr, settings) {
	initDatePickers();
	initTimePickers();
	initSelectOne();
	initChoices();
	initShowTtLinkTypeFrmPair();
});

global.naja.addEventListener('complete', e => {
	initDatePickers();
	initTimePickers();
	initSelectOne();
	initChoices();
	initShowTtLinkTypeFrmPair();
});

document.addEventListener('formInputsInit', e => {
	initChoices();
})

document.addEventListener('contentLangChange', e => {
	document.querySelectorAll('select[data-choice][data-content-lang]').forEach(el => {
		if (el.dataset.contentLang !== e.detail.lang)
			el.closest('.choices').style.display = 'none';
		else
			el.closest('.choices').style.display = 'block';
	})

	initChoices();
})

document.addEventListener('click', e => {
	if (e.target.dataset.translateTo) {
		const targetLang = e.target.dataset.translateTo;

		if (targetLang.length === 2) {
			const labelWrap   = e.target.closest('.label-wrap');
			const pairWrap    = e.target.closest('.frm__pair');
			const input       = pairWrap.querySelector('[name="' + labelWrap.dataset.name + '[' + window.defaultLang + ']"]');
			const targetInput = pairWrap.querySelector('[name="' + labelWrap.dataset.name + '[' + targetLang + ']"]');

			if (input && targetInput) {
				global.naja.makeRequest('post', window.translatorLinkDeepL, {
					'text'      : input.value,
					'sourceLang': window.defaultLang,
					'targetLang': targetLang,
				}, {history: false}).then(response => {
					if (response.result) {
						const isEditorWrap = targetInput.closest('.frm__type-editor');
						if(isEditorWrap) {
							const targetEditorTextarea = isEditorWrap.querySelector('.ck_textarea[data-content-lang="'+targetInput.dataset.contentLang+'"]');

							if(targetEditorTextarea) {
								if(CKEDITOR !== undefined && CKEDITOR.instances[targetEditorTextarea.id] !== undefined) {
									CKEDITOR.instances[targetEditorTextarea.id].setData(response.result);
								} else {
									targetEditorTextarea.innerHTML = response.result;
								}
							}
						} else {
							targetInput.value = response.result;
						}

						e.target.classList.add('btn-success');
					}
				});

				e.preventDefault();
				return false;
			}
		}
	}
});
