export const addEventForChild = (parent, eventName, childSelector, cb) => {
	parent.addEventListener(eventName, function (event) {
		const clickedElement = event.target,
		      matchingChild  = clickedElement.closest(childSelector);
		if (matchingChild) cb(matchingChild)
	})
};

export function switchClass(element, className) {
	if (element.classList.contains(className)) {
		element.classList.remove(className);
	} else {
		element.classList.add(className);
	}
}

export async function getJson(url) {
	let response = await fetch(url);
	let data     = await response.json();
	return data;
}

export function addLoaderToElement(element) {
	const loader = document.createElement('div');
	loader.classList.add('loading-overlay', 'loading-overlay--small');
	loader.innerHTML = '<div class="spinner">' +
	                   '<div class="rect1"></div>' +
	                   '<div class="rect2"></div>' +
	                   '<div class="rect3"></div>' +
	                   '<div class="rect4"></div>' +
	                   '<div class="rect5"></div>' +
	                   '</div>';

	element.append(loader);

	return loader;
}
