import { addEventForChild, openModal } from './utils/utilities';
import { Fancybox } from '@fancyapps/ui';

document.addEventListener('DOMContentLoaded', () => {
	const darker = document.querySelector('.darker');
	const body   = document.querySelector('body');

	if (darker) {
		addEventForChild(body, 'click', '[data-modal]', el => {
			const modalTarget = el.dataset.modal;
			if (modalTarget) {
				document.querySelectorAll(modalTarget).forEach(el => el.classList.add('modal--active'));
			}
			darker.classList.add('darker--active');
		});

		darker.addEventListener('click', () => {
			document.querySelectorAll('.modal').forEach(el => {
				document.documentElement.classList.remove('overflow-hidden');
				let m = el.closest('.modal');
				if (m) {
					m.classList.remove('modal--active');
					if (m.dataset && m.dataset.destroyOnClose === 'true')
						m.remove();
				}

				hideLastDarker();
			});
		});

		addEventForChild(body, 'click', '.modal__close, [data-modal-close]', el => {
			document.documentElement.classList.remove('overflow-hidden');
			let m = el.closest('.modal');
			if (m) {
				m.classList.remove('modal--active');
				if (m.dataset && m.dataset.destroyOnClose === 'true')
					m.remove();
			}

			hideLastDarker();
		});
	}
});

document.addEventListener('click', e => {
	if (e.target.dataset.najaUrl) {
		let url  = e.target.dataset.najaUrl;
		let data = e.target.dataset.najaData ? JSON.parse(e.target.dataset.najaData) : {};
		global.naja.makeRequest('GET', url, data);
	}
});

global.naja.addEventListener('success', (e) => {
	if (e.response && e.response.hideModal === true) {
		hideLastDarker();

		if (typeof Fancybox !== 'undefined' && Fancybox.close) {
			Fancybox.close();
		}
	}
});

const hideLastDarker = () => {
	let elems = document.querySelectorAll('.darker--active');
	let elem  = elems ? elems[elems.length - 1] : null;
	if (elem) {
		if (elem.dataset.onlyOnce !== undefined) {
			elem.remove();
		} else {
			elem.classList.remove('darker--active');
		}
	}
};

global.naja.addEventListener('success', (e) => {
	if (!e.response) {
		return;
	}

	if (e.response.toModal && e.response.hideModal !== true) {
		const toModalContent = e.response.snippets[e.response.toModal];

		if (toModalContent) {
			Fancybox.show([{
				type: 'html',
				src : toModalContent
			}], {
				closeButton: false,
				on         : {
					done: (fancybox, slide) => {
						slide.contentEl.querySelectorAll('.ajax').forEach(el => {
							global.naja.uiHandler.bindUI(el);
						});

						slide.contentEl.addEventListener('click', e => {
							if (e.target.classList.contains('modal__close')) {
								Fancybox.close();
							}
						});
					}
				}
			});

			hideLastDarker();

			return;
		}
	}

	try {
		const requestKey = e.response.requestKey;

		if (requestKey === 'baseInfoPopup') {
			const texts = e.response.texts;
			let h1      = texts.h1;
			let content = texts.content;

			if (document.activeElement && document.activeElement.dataset.najaRequest !== undefined) {
				try {
					let najaRequest = JSON.parse(document.activeElement.dataset.najaRequest);

					if (najaRequest.config.title) {
						h1 = texts[najaRequest.config.title];
					}

					if (najaRequest.config.content) {
						content = texts[najaRequest.config.content];
					}
				} catch (e) {

				}
			}

			openModal(h1, content);
		}
	} catch (e) {
		console.error(e);
	}

	if (e.response.createModalData === undefined)
		return;

	const data   = e.response.createModalData;
	const darker = document.querySelector('.darker');

	let modalWrap = document.createElement('div');
	modalWrap.classList.add('modal', 'modal--active');
	modalWrap.dataset.destroyOnClose = true;

	if (data.modalClass)
		modalWrap.classList.add(data.modalClass);

	if (data.title) {
		let modalTitleWrap = document.createElement('div');
		modalTitleWrap.classList.add('modal__header');

		let modalTitleText       = document.createElement('span');
		modalTitleText.innerHTML = data.title;

		let modalTitleClose = document.createElement('div');
		modalTitleClose.classList.add('modal__close');

		modalTitleWrap.append(modalTitleText, modalTitleClose);
		modalWrap.append(modalTitleWrap);
	}

	if (data.text) {
		let modalBodyWrap = document.createElement('div');
		modalBodyWrap.classList.add('modal__body-wrap');

		let modalBody = document.createElement('div');
		modalBody.classList.add('modal__body');

		let modalBodyInner = document.createElement('div');
		modalBodyInner.classList.add('inner');
		modalBodyInner.innerHTML = data.text;

		modalBody.append(modalBodyInner);
		modalBodyWrap.append(modalBody);
		modalWrap.append(modalBodyWrap);
	}

	document.body.append(modalWrap);
	darker.classList.add('darker--active');
});
