import PNotify from 'pnotify/dist/es/PNotify';
import * as PNotifyButtons from 'pnotify/dist/es/PNotifyButtons';
import {checkMedia} from "core/js/utils/utilities";

export class Flashes {
	constructor(naja) {
		let snippetFlashes = document.getElementById('snippet--flashes');
		if (snippetFlashes.firstChild) {
			this.pushNotifyFromSnippet(snippetFlashes.innerHTML);
		}

		global.naja.snippetHandler.addEventListener('afterUpdate', e => {
			if (e.snippet.id === 'snippet--flashes') {
				try {
					this.pushNotifyFromSnippet(e.content);

					e.preventDefault();
				} catch (e) {
				}
			}
		});

		document.addEventListener('pushFlash', e => {
			this.pushNotify(e.detail.type, e.detail.html);
		});
	}

	pushNotifyFromSnippet(content) {
		let el       = document.createElement('div');
		el.innerHTML = content;

		for (let i in el.children) {
			let child = el.children[i];

			if (!child.dataset || !child.dataset.type)
				return true;

			this.pushNotifyFromHtmlEl(child);
		}
	}

	pushNotifyFromHtmlEl(el) {
		let type = el.dataset.type;

		if (type == 'danger' || type == 'warning')
			type = 'error';

		this.pushNotify(type, el.innerHTML);
	}

	pushNotify(type, html) {
		let top  = 25;

		const cart = document.querySelector('.shop-header__cart');
		if (cart) {
			const bounding = cart.getBoundingClientRect();
			const isMobile = checkMedia(document.body.dataset.responsiveBarThreshold);
			top            = bounding.y + (isMobile ? 0 : window.scrollY) + bounding.height + 10;
		}

		document.querySelectorAll('.ui-pnotify').forEach(el => {
			top += el.getBoundingClientRect().height + 10;
		});

		const PNotifyAlert = PNotify.alert({
			delay      : 1500,
			text       : html,
			textTrusted: true,
			type       : type,
			stack      : {
				dir1     : 'down',
				dir2     : 'left',
				firstpos1: top,
				firstpos2: 25,
			},
			modules: {
				Buttons: {
					closer: true,
					sticker: false
				},
			},
		});

		PNotifyAlert.on("click", () => {
			PNotifyAlert.close();
		});
	}
}
