<?php declare(strict_types = 1);

namespace Core\AdminModule\Components\DashboardWidgets;

use Core\Model\Parameters;
use Dashboard\AdminModule\Components\Widget;
use Dashboard\AdminModule\Model\Provider\IWidget;

class FastLinks extends Widget implements IWidget
{
	protected string $key = 'coreFastLinks';

	public function render(): void
	{
		$params = Parameters::load('adminDashboard.fastLinks');

		if (!$params)
			return;

		$this->template->links = $params;
		$this->template->render($this->getTemplateFile());
	}
}
