<?php declare(strict_types = 1);

namespace Core\AdminModule\Model;

use Core\Model\WebColors;
use Nette\Utils\FileSystem;
use ScssPhp\ScssPhp\Compiler;
use ScssPhp\ScssPhp\OutputStyle;

class ColorsCompiler
{
	protected WebColors $webColors;

	public function __construct(WebColors $webColors)
	{
		$this->webColors = $webColors;
	}

	public function compile(string $siteIdent = ''): bool
	{
		$this->webColors->clearCache();
		$vars = $this->webColors->getColors($siteIdent);

		$scss = new Compiler();

		$scss->addVariables($vars);
		$scss->setImportPaths(SRC_DIR . '/core/assets/front/src/globalScss/');

		$filePrefix = $siteIdent === '' ? $siteIdent : $siteIdent . '_';

		$oldFile = ASSETS_DIR . '/front/dist/' . $filePrefix . 'webColorsOld.css';
		$newFile = ASSETS_DIR . '/front/dist/' . $filePrefix . 'webColors.css';
		$tmpFile = TMP_DIR . '/webColors.tmp';

		try {
			$scss->setOutputStyle(OutputStyle::COMPRESSED);

			file_put_contents($tmpFile, $scss->compileString('@import "settings.scss";')->getCss());
			if (file_exists($newFile)) {
				FileSystem::rename($newFile, $oldFile);
			}

			FileSystem::rename($tmpFile, $newFile);
			FileSystem::delete($tmpFile);
			FileSystem::delete(TMP_DIR . '/cache/latte');
		} catch (\Exception $e) {
			bdump($e->getMessage());

			return false;
		}

		return true;
	}
}
