<?php declare(strict_types = 1);

namespace Core\AdminModule\Presenters;

abstract class SecuredPresenter extends BasePresenter
{
	protected function startup()
	{
		parent::startup();
	}

	public function checkRequirements($element): void
	{
		$user = $this->getUser();
		if (!$user->isLoggedIn()) {
			$this->forward(':Users:Admin:Login:');
		}

		$hasAccess = false;
		foreach ($user->getRoles() as $role) {
			if (in_array($role, $this->systemConfig->get('adminRoles')) || $user->isAllowed('Core:Admin', 'access')) {
				$hasAccess = true;
				break;
			}
		}

		if (!$hasAccess) {
			$user->logout(true);
			$this->forward(':Users:Admin:Login:');
		}

		parent::checkRequirements($element);
	}

	/*******************************************************************************************************************
	 * =============================== Handle
	 */

	public function handleLogout(): void
	{
		$this->getUser()->logout(true);
		$this->redirect(':Users:Admin:Login:');
	}
}
