<?php declare(strict_types = 1);

namespace Core\AdminModule\Presenters;

use Core\AdminModule\Components\DataForm;
use Core\AdminModule\Components\IDataFormFactory;
use Core\AdminModule\Components\Settings\ISiteFormFactory;
use Core\AdminModule\Components\Settings\IWebSettingsFormFactory;
use Core\AdminModule\Components\Settings\SiteForm;
use Core\AdminModule\Components\Settings\WebSettingsForm;
use Core\AdminModule\Model\Sites;
use Nette\Application\BadRequestException;
use Nette\Application\UI\Multiplier;

class SettingsPresenter extends BasePresenter
{
	/** @var Sites @inject */
	public $sitesService;

	/**
	 * @return void
	 * @throws BadRequestException
	 */
	protected function startup()
	{
		parent::startup();
		if (!$this->getUser()->isAllowed($this->getFullModuleName(), 'settings')) {
			$this->error();
		}

		$this->setHeader('admin.title.cmsSettings', 'fas fa-cogs');
	}

	public function actionGlobalData(): void
	{
		$this->setHeader('admin.title.globalData', 'fas fa-globe');
	}

	/*******************************************************************************************************************
	 * ===============================  Render
	 */

	public function renderDefault(): void
	{
		$this->template->sites = $this->sitesService->getAll();
	}

	/*******************************************************************************************************************
	 * ===============================  Components
	 */

	protected function createComponentSiteForm(ISiteFormFactory $factory): Multiplier
	{
		return new Multiplier(function(string $ident) use ($factory) : SiteForm {
			return $factory->create($ident);
		});
	}

	protected function createComponentWebSettingsForm(IWebSettingsFormFactory $factory): Multiplier
	{
		return new Multiplier(function(string $ident) use ($factory) : WebSettingsForm {
			return $factory->create($ident);
		});
	}

	protected function createComponentGlobalDataForm(IDataFormFactory $factory): DataForm
	{
		return $factory->create('globalData');
	}
}
