<?php declare(strict_types = 1);

namespace Core\AdminModule\Presenters;

use Core\AdminModule\Components\Variables\IVariablesGridFactory;
use Core\AdminModule\Components\Variables\VariablesGrid;

class VariablesPresenter extends BasePresenter
{
	public const ICON = 'fas fa-list';

	/*******************************************************************************************************************
	 * ============================== Actions
	 */

	public function actionDefault(): void
	{
		$this->setTitle($this->t('core.title.variables'));
		$this->setHeader('core.title.variables', self::ICON);

		$this['navigation']->setData([
			'header' => [
				[
					'title' => 'core.menu.addVariable',
					'link'  => 'variablesGrid:add!',
					'ico'   => 'plus',
					'class' => 'ajax',
				],
			],
		]);
	}

	protected function createComponentVariablesGrid(IVariablesGridFactory $factory): VariablesGrid
	{
		return $factory->create();
	}
}
