<?php declare(strict_types = 1);

namespace Core\ApiModule\Api\V1\Controllers;

use Apitte\Core\Annotation\Controller\Path;
use Apitte\Core\Annotation\Controller\Method;
use Apitte\Core\Http\ApiRequest;
use Apitte\Core\Http\ApiResponse;
use Core\ApiModule\Model\Services\AppState;
use Core\ApiModule\Model\Utils\AppConfiguration;

/**
 * @Path("/app")
 */
class AppController extends BaseController
{
	protected AppState $appState;

	public function __construct(AppState $appState)
	{
		$this->appState = $appState;
	}

	/**
	 * @Path("/configuration")
	 * @Method("GET")
	 */
	public function configuration(ApiRequest $request, ApiResponse $response): ApiResponse
	{
		$result['testMode'] = AppConfiguration::testMode();
		$result['sessionSavePath'] = AppConfiguration::sessionSavePath();
		$result['consoleUrl'] = AppConfiguration::consoleUrl();
		$result['isFrontTranslated'] = $this->appState->isFrontTranslated();
		$result['isSetSmtpUsername'] = $this->appState->isSetSmtpUsername();

		$comgateTestMode = AppConfiguration::comgateTestMode();
		if ($comgateTestMode !== null) {
			$result['comgate']['test'] = $comgateTestMode;
		}

		return $response->writeJsonBody($result)
						->withStatus(ApiResponse::S200_OK);
	}

	/**
	 * @Path("/state")
	 * @Method("GET")
	 */
	public function state(ApiRequest $request, ApiResponse $response): ApiResponse
	{
		$result = [];
		$result['existEshopProductsComparisonFeeds'] = $this->appState->existEshopProductsComparisonFeeds();

		return $response->writeJsonBody($result)
						->withStatus(ApiResponse::S200_OK);
	}

}