<?php declare(strict_types = 1);

namespace Core\Console\Seo;

use Nette\Application\LinkGenerator;
use Core\FrontModule\Model\SiteMap;
use Core\Model\Lang\Langs;
use Doctrine;
use Doctrine\ORM\Tools\Console\Command\SchemaTool\AbstractCommand;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Style\SymfonyStyle;

/**
 * Class GenerateRobotsTxt
 * @package Core\Console\Seo
 */
class GenerateRobotsTxt extends AbstractCommand
{
	/** @var SiteMap @inject */
	public $siteMap;

	/** @var LinkGenerator @inject */
	public $linkGenerator;

	/** @var Langs @inject */
	public $langs;

	protected function configure(): void
	{
		$this->setName('seo:generate-robots-txt')->setDescription('Generate robots.txt');
	}

	protected function executeSchemaCommand(InputInterface $input, OutputInterface $output, Doctrine\ORM\Tools\SchemaTool $schemaTool, array $metadatas, SymfonyStyle $ui)
	{
		$output->writeln('GENERATE ROBOTS.TXT');

		try {
			$content = "User-agent: *\n" .
				"Disallow: /admin\n" .
				"Disallow: /assets/admin\n" .
				"Disallow: /assets/admin2\n" .
				"Disallow: /*?do=measuringCodesTurnOn\n" .
				"Disallow: /trafficbot.life\n";

			$content .= "\n";

			file_put_contents(WWW_DIR . '/robots.txt', $content);

			$output->writeLn('<info>[OK] - robots.txt created</info>');
		} catch (\Exception $e) {
			$output->writeln('<error>[ERROR] - ' . $e->getMessage() . '</error>');
		}

		return 1;
	}
}
