<?php declare(strict_types = 1);

namespace Core\Console\Utils;

use Core\AdminModule\Model\Redirects;
use Doctrine;
use Doctrine\ORM\Tools\Console\Command\SchemaTool\AbstractCommand;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Style\SymfonyStyle;

class ValidateRedirects extends AbstractCommand
{
	/** @var Redirects @inject */
	public $redirects;

	protected function configure(): void
	{
		$this->setName('utils:validate-redirects')
			->addOption('offset', null, InputOption::VALUE_REQUIRED)
			->addOption('limit', null, InputOption::VALUE_REQUIRED);
	}

	protected function executeSchemaCommand(InputInterface $input, OutputInterface $output, Doctrine\ORM\Tools\SchemaTool $schemaTool, array $metadatas, SymfonyStyle $ui)
	{
		$output->writeln('VALIDATE REDIRECTS');

		try {
			try {
				$this->redirects->validateRedirects((int) $input->getOption('offset'), (int) $input->getOption('limit'));
				$output->writeLn('<info>[OK] - data updated</info>');
			} catch (\Exception $e) {
				$output->writeln('<error>[ERROR] - ' . $e->getMessage() . '</error>');
			}
		} catch (\Exception $e) {
			$output->writeln('<error>[ERROR] - ' . $e->getMessage() . '</error>');
		}

		return 0;
	}
}
