<?php declare(strict_types = 1);

namespace Core\CronModule\Presenters;

use Core\Model\Helpers\Ares;
use Core\Model\Helpers\OrsrSk;
use Nette\Utils\FileSystem;

class LoadIcoDataPresenter extends BasePresenter
{
	public function actionLoadData(): void
	{
		$ico     = $this->getParameter('ico');
		$country = strtolower($this->getParameter('country', ''));
		$data    = [];

		$ares             = new Ares();
		$orsrSk           = new OrsrSk();
		$orsrSk->dirCache = TMP_DIR . '/orsr/';
		FileSystem::createDir($orsrSk->dirCache);

		if ($country) {
			$country = strtolower($country);
			switch ($country) {
				case 'cz':
					$data = $ares->findByIco($ico);
					break;
				case 'sk':
					$data = $orsrSk->findByICO($ico);
			}
		} else {
			$data = $ares->findByIco($ico);
			if (!$data) {
				$data = $orsrSk->findByICO($ico);
			}
		}

		$this->sendJson($data);
	}
}
