<?php declare(strict_types = 1);

namespace Core\FrontModule\Model;

use Core\Model\CookieAdditionalServices;
use Core\Model\Entities\CookieAdditionalService;
use Core\Model\Helpers\BaseFrontEntityService;
use Core\Model\Sites;
use Nette\Caching\Cache;
use Nette\DI\Container;

class CookieServices extends BaseFrontEntityService
{
	protected $entityClass = CookieAdditionalService::class;
	protected Container $container;
	protected CookieAdditionalServices $cookieAdditionalServices;
	protected Sites $sites;
	
	public const CACHE_NAMESPACE = 'cookieServices';

	public array $cacheDep = [
		Cache::TAGS   => ['cookieAdditionalServices', 'coreSettings'],
		Cache::EXPIRE => '1 year',
	];

	public function __construct(Container $container, CookieAdditionalServices $cookieAdditionalServices, Sites $sites)
	{
		$this->container = $container;
		$this->cookieAdditionalServices = $cookieAdditionalServices;
		$this->sites = $sites;
	}

	public function getCache(): Cache
	{
		if ($this->cache === null) {
			$this->cache = new Cache($this->cacheStorage, self::CACHE_NAMESPACE);
		}

		return $this->cache;
	}

	public function getAllWithDefaults(): array
	{
		$locale = $this->translator->getLocale();
		$site = $this->sites->getCurrentSite()->getIdent();
		$key    = 'cookieAdditionalServices_' . $locale . '_' . $site;

		return $this->getCache()->load($key, function(&$dep) {
			$dep = $this->cacheDep;

			return array_keys($this->cookieAdditionalServices->getAllWithDefaults());
		});
	}

}