<?php declare(strict_types = 1);

namespace Core\FrontModule\Model\Subscribers;

use Core\Components\Cookie\ICookieBarFactory;
use Core\Components\Flashes\Flashes;
use Core\Model\Event\ControlEvent;
use Core\Model\SystemConfig;
use Core\Model\UI\FrontPresenter;
use Nette\Http\Request;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class FrontPresenterSubscriber implements EventSubscriberInterface
{
	protected ICookieBarFactory $cookieBarFactory;
	protected Request           $request;

	public function __construct(ICookieBarFactory $cookieBarFactory, Request $request)
	{
		$this->cookieBarFactory = $cookieBarFactory;
		$this->request          = $request;
	}

	public static function getSubscribedEvents(): array
	{
		return [
			FrontPresenter::class . '::beforeRender' => 'beforeRender',
		];
	}

	public function beforeRender(ControlEvent $event): void
	{
		/** @var FrontPresenter $presenter */
		$presenter = $event->control;

		if (Flashes::hasNewFlashes()) {
			$presenter->redrawControl('flashes');
		}

		if (SystemConfig::load('cookieBar.enable', false) && !$this->request->isAjax()) {
			$presenter->addHeadStartComponent($this->cookieBarFactory->create(), 'cookieBar');
		}
	}
}
