<?php declare(strict_types = 1);

namespace Core\Model;

use Jaybizzle\CrawlerDetect\CrawlerDetect;

class BotDetect
{
	protected static ?CrawlerDetect $crawlerDetect = null;

	public static function getCrawlerDetect(): CrawlerDetect
	{
		if (self::$crawlerDetect === null) {
			self::$crawlerDetect = new CrawlerDetect();
		}

		return self::$crawlerDetect;
	}

	public static function isBot(): bool
	{
		$crawlerDetect = self::getCrawlerDetect();

		$userAgent = empty($_SERVER['HTTP_USER_AGENT']) ? false : $_SERVER['HTTP_USER_AGENT'];

		$ipAddresses = ['134.119.219.71', '89.221.223.75', '131.220.6.152', '173.252.127.18'];

		$xHttpClient = ['Collabim'];

		return !$userAgent || $crawlerDetect->isCrawler()
			|| (isset($_SERVER['REMOTE_ADDR']) && in_array($_SERVER['REMOTE_ADDR'], $ipAddresses))
			|| (isset($_SERVER['HTTP_X_CLIENT']) && in_array($_SERVER['HTTP_X_CLIENT'], $xHttpClient));
	}
}
