<?php declare(strict_types = 1);

namespace Core\Model\Dao;

class Country
{
	protected string $id;
	protected string $iso3166_1;
	public string    $name;

	public function __construct(
		string $id,
		string $iso3166_1,
		string $name
	)
	{
		$this->id        = $id;
		$this->iso3166_1 = $iso3166_1;
		$this->name      = $name;
	}

	public function getId(): string { return $this->id; }
	public function getIso31661(): string { return $this->iso3166_1; }
	public function getName(): string { return $this->name; }
}
