<?php declare(strict_types = 1);

namespace Core\Model\Entities;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="core__cookie_additional_service_in_site")
 * @ORM\Entity
 */
class CookieAdditionalServiceInSite
{
	/**
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="CookieAdditionalService")
	 * @ORM\JoinColumn(name="cookie_additional_service_id", referencedColumnName="id", nullable=false, onDelete="CASCADE")
	 */
	public CookieAdditionalService $cookieAdditionalService;

	/**
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="Core\Model\Entities\Site")
	 * @ORM\JoinColumn(name="site_id", referencedColumnName="ident", nullable=false, onDelete="CASCADE")
	 */
	public Site $site;

	public function __construct(CookieAdditionalService $cookieAdditionalService, Site $site)
	{
		$this->cookieAdditionalService = $cookieAdditionalService;
		$this->site = $site;
	}

}