<?php declare(strict_types = 1);

namespace Core\Model\Entities;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="core__public_holiday_text")
 * @ORM\Entity
 */
class PublicHolidayText
{
	/**
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="PublicHoliday", inversedBy="texts")
	 * @ORM\JoinColumn(referencedColumnName="id", onDelete="CASCADE", nullable=false)
	 */
	protected PublicHoliday $publicHoliday;

	/**
	 * @ORM\Id
	 * @ORM\Column(type="string", length=255, nullable=false, options={"default":"cs"})
	 */
	protected string $lang = 'cs';

	/**
	 * @ORM\Column(type="string", length=255, nullable=true)
	 */
	public ?string $title = null;

	/**
	 * @ORM\Column(type="string", length=255, nullable=true)
	 */
	public ?string $description = null;

	public function __construct(PublicHoliday $publicHoliday, string $lang = 'cs')
	{
		$this->publicHoliday = $publicHoliday;
		$this->lang          = $lang;
	}

	public function getPublicHoliday(): PublicHoliday { return $this->publicHoliday; }

	public function getLang(): string { return $this->lang; }
}
