<?php declare(strict_types = 1);

namespace Core\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use Nette\Utils\DateTime;

/**
 * @ORM\Table(name="core__redirect")
 * @ORM\Entity
 */
class Redirect
{
	use TId;

	public const CACHE_NAMESPACE = 'coreRedirect';

	/**
	 * @ORM\Column(name="title", type="string", length=255, nullable=false)
	 */
	public string $title;

	/**
	 * @ORM\Column(name="`from`", type="string", length=255, nullable=false)
	 */
	public string $from;

	/**
	 * @ORM\Column(name="`to`", type="string", length=255, nullable=false)
	 */
	public string $to;

	/**
	 * @ORM\Column(name="is_locked", type="smallint", nullable=false, options={"default": 0})
	 */
	public int $isLocked = 0;

	/**
	 * @ORM\Column(name="`package`", type="string", length=255, nullable=true)
	 */
	public ?string $package = null;

	/**
	 * @ORM\Column(name="relation_key", type="string", length=255, nullable=true)
	 */
	public ?string $relationKey = null;

	/**
	 * @ORM\Column(name="relation_value", type="string", length=255, nullable=true)
	 */
	public ?string $relationValue = null;

	/**
	 * @ORM\Column(name="redirect_code", type="string", length=255, nullable=false, options={"default": "301"})
	 */
	public string $redirectCode = '301';

	/**
	 * @ORM\Column(name="is_published", type="smallint", nullable=false, options={"default": 1})
	 */
	public int $isPublished = 1;

	/**
	 * @var int
	 * @ORM\Column(name="views", type="integer", nullable=false, options={"default": 0})
	 */
	public $views;

	/**
	 * @var array
	 * @ORM\Column(name="params", type="array", nullable=true)
	 */
	protected $params;

	/**
	 * @ORM\Column(name="site_ident", type="string", length=255, nullable=true)
	 */
	public ?string $siteIdent = null;

	/**
	 * @ORM\Column(name="lang", type="string", length=5, nullable=true)
	 */
	public ?string $lang = null;

	/**
	 * @ORM\Column(name="last_check", type="datetime", nullable=true)
	 */
	public ?\DateTimeInterface $lastCheck = null;

	/**
	 * @ORM\Column(name="last_status", type="string", length=255, nullable=true)
	 */
	public ?string $lastStatus = null;

	/**
	 * @ORM\Column(name="created", type="datetime", nullable=true)
	 */
	public ?\DateTimeInterface $created = null;

	public function __construct(string $title, string $from, string $to)
	{
		$this->title        = $title;
		$this->from         = $from;
		$this->to           = $to;
		$this->isLocked     = 0;
		$this->redirectCode = '301';
		$this->isPublished  = 1;
		$this->params       = [];
		$this->views        = 0;
		$this->created      = new DateTime();
	}

	public function getParams(): array { return $this->params ?: []; }

	/**
	 * @return mixed|null
	 */
	public function getParam(string $key) { return $this->params[$key] ?? null; }

	/**
	 * @param mixed $value
	 */
	public function setParam(string $key, $value): void
	{
		if ($value) {
			$this->params[$key] = $value;
		} else {
			unset($this->params[$key]);
		}
	}

	public function updateCheck(string $status): void
	{
		$this->lastCheck  = new DateTime();
		$this->lastStatus = $status;
	}
}
