<?php declare(strict_types = 1);

namespace Core\Model\Entities\Repository;

use Core\Model\Entities\QueryBuilder;
use Doctrine\ORM\AbstractQuery;
use Doctrine\ORM\Proxy\Proxy;

class SortableRepository extends \Gedmo\Sortable\Entity\Repository\SortableRepository
{
	/**
	 * @param string|array $criteria
	 * @param string|null  $value
	 * @param string|array $orderBy
	 * @param string|null  $key
	 *
	 * @return array
	 */
	public function findPairs($criteria, $value = null, $orderBy = [], $key = null)
	{
		if (!is_array($criteria)) {
			$key      = is_array($orderBy) ? (string) $orderBy[0] : (string) $orderBy;
			$orderBy  = $value;
			$value    = $criteria;
			$criteria = [];
		}

		if (!is_array($orderBy)) {
			$key     = (string) $orderBy;
			$orderBy = [];
		}

		if (empty($key)) {
			$key = $this->getClassMetadata()->getSingleIdentifierFieldName();
		}

		/** @var QueryBuilder $qb */
		$qb = $this->createQueryBuilder('e');

		$qb->whereCriteria($criteria)
			->select(["e.$value", "e.$key"])
			->resetDQLPart('from')->from($this->getEntityName(), 'e', 'e.' . $key);
		$query = $qb->autoJoinOrderBy($orderBy)->getQuery();

		return array_map(static function($row) {
			return reset($row);
		}, $query->getResult(AbstractQuery::HYDRATE_ARRAY));
	}

	/**
	 * @param int|string $id
	 */
	public function getReference($id): ?Proxy
	{
		/** @var Proxy|null $reference */
		$reference = $this->getEntityManager()->getReference($this->_entityName, $id);

		return $reference;
	}

	/**
	 * @param int $id
	 * @param int $position
	 */
	public function setPosition($id, $position): bool
	{
		$item = $this->getReference($id);
		if ($item) {
			if (method_exists($item, 'setPosition')) {
				$item->setPosition($position);
			}

			$em = $this->getEntityManager();
			$em->persist($item);
			$em->flush();

			return true;
		}

		return false;
	}
}
