<?php declare(strict_types = 1);

namespace Core\Model\Entities;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="core__static_text_translation")
 * @ORM\Entity
 */
class StaticTextTranslation
{
	/**
	 * @ORM\Id
	 * @ORM\Column(type="integer", nullable=false)
	 * @ORM\GeneratedValue
	 */
	public ?int $messageId = null;

	/**
	 * @ORM\Column(type="string", nullable=false)
	 */
	public string $id;

	/**
	 * @ORM\Column(type="string", nullable=false)
	 */
	public string $locale;

	/**
	 * @ORM\Column(type="string", nullable=false)
	 */
	public string $message;

	public function __construct(string $id, string $locale, string $message)
	{
		$this->id      = $id;
		$this->locale  = $locale;
		$this->message = $message;
	}

}
