<?php declare(strict_types = 1);

namespace Core\Model\Entities;

use Doctrine;
use Doctrine\ORM\Event\LifecycleEventArgs;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Contributte\Translation\Translator;
use Nette\SmartObject;

class TranslateListener implements EventSubscriberInterface
{
	use SmartObject;

	protected Translator $translator;

	public function __construct(
		Translator $translator
	)
	{
		$this->translator = $translator;
	}

	public static function getSubscribedEvents(): array
	{
		return [];
	}

	/**
	 * @ORM\PostLoad
	 */
	public function postLoadHandler(object $entity, LifecycleEventArgs $event): void
	{
		if (property_exists($entity, 'locale')) {
			$entity->locale = $this->translator->getLocale();
		}
	}
}
