<?php declare(strict_types = 1);

namespace Core\Model\Event;

use DynamicModule\Model\Entities\Member;

class InstagramMediaEvent
{
	public string $profileId;
	public string $mediaId;
	public array  $mediaData;

	/** @var object|Member */
	public object $member;

	public function __construct(string $profileId, string $mediaId, object $member, array $mediaData)
	{
		$this->profileId = $profileId;
		$this->mediaId   = $mediaId;
		$this->member    = $member;
		$this->mediaData = $mediaData;
	}
}
