<?php declare(strict_types = 1);

namespace Core\Model\Event;

use Core\Model\Dao\Site;
use Symfony\Contracts\EventDispatcher\Event;
use Thepixeldeveloper\Sitemap\Url;

class SitemapGeneratorEvent extends Event
{
	public Site   $site;
	public string $lang;
	public string $domain;
	public string $group;

	/** @var Url[] */
	protected array $result = [];

	public function __construct(Site $site, string $lang, string $domain, string $group)
	{
		$this->site   = $site;
		$this->lang   = $lang;
		$this->domain = $domain;
		$this->group  = $group;
	}

	public function addToResult(Url $url): void
	{
		$this->result[] = $url;
	}

	public function getResult(): array
	{
		return $this->result;
	}
}
