<?php declare(strict_types = 1);

namespace Core\Model\Event;

use Symfony\Contracts\EventDispatcher\Event;

class TtSearchEvent extends Event
{
	public string   $q;
	public array    $inputs;
	public array    $values;
	protected array $result = [];

	public function __construct(string $q, array $inputs, array $values)
	{
		$this->q      = $q;
		$this->inputs = $inputs;
		$this->values = $values;
	}

	/**
	 * @param mixed $data
	 */
	public function addResult(string $type, $data): self
	{
		$this->result[$type] = $data;

		return $this;
	}

	public function getResult(): array { return $this->result; }
}
