<?php declare(strict_types = 1);

namespace Core\Model\Helpers;

use Nette\Utils\DateTime;
use Nette\Utils\FileSystem;

class CoreHelper
{
	protected static ?bool $isCompiled = null;

	public static function isCompiled(): bool
	{
		if (self::$isCompiled === null) {
			self::$isCompiled = file_exists(TMP_DIR . '/compiled');
		}

		return self::$isCompiled;
	}

	public static function setCompiled(): void
	{
		if (!self::isCompiled()) {
			FileSystem::write(TMP_DIR . '/compiled', (string) time());
		}
	}

	public static function getLastSystemUpdate(): ?DateTime
	{
		$time = @file_get_contents(DATA_DIR . DS . 'core' . DS . 'lastSystemUpdate');
		try {
			if ($time) {
				$date = DateTime::from(trim($time));

				if ($date instanceof DateTime) {
					return $date;
				}
			}
		} catch (\Exception $e) {
		}

		return null;
	}
}
