<?php declare(strict_types = 1);

namespace Core\Model\Helpers;

class DatabaseConfig
{
	public static array $config = [];

	protected static ?string $configKey = null;

	public static function getUser(): string
	{
		return (string) self::$config[self::getConfigKey()]['user'];
	}

	public static function getPassword(): string
	{
		return (string) self::$config[self::getConfigKey()]['password'];
	}

	public static function getDbName(): string
	{
		return (string) (self::$config[self::getConfigKey()]['dbname'] ?? self::$config['default']['dbname']);
	}

	public static function getHost(): string
	{
		return (string) (self::$config[self::getConfigKey()]['host'] ?? self::$config['default']['host']);
	}

	public static function getDsn(?string $dbName = null, ?string $host = null): string
	{
		$result = 'mysql:dbname=' . ($dbName ?: self::getDbName()) . ';';

		if (strtolower((string) PHP_OS) === 'linux' && self::$config[self::getConfigKey()]['host'] === null) {
			$host = '/var/lib/mysql/mysql.sock';
		} else {
			$host = ($host ?: self::$config[self::getConfigKey()]['host']) ?: '127.0.0.1';
		}

		if (Strings::endsWith($host, '.soc')) {
			$result .= 'unix_socket=' . $host;
		} else {
			$result .= 'host=' . $host;
		}

		return $result;
	}

	public static function getConfigKey(): string
	{
		$requestUri = (string) $_SERVER['REQUEST_URI'];
		$httpHost   = (string) $_SERVER['HTTP_HOST'];

		if (is_null(self::$configKey)) {
			if ((php_sapi_name() === 'cli' || strpos($requestUri, '/cron') === 0)
				&& isset(self::$config['cron']['user'])
				&& isset(self::$config['cron']['password'])) {
				self::$configKey = 'cron';
			} else if ((Strings::startsWith($requestUri, '/admin') || Strings::startsWith($httpHost, 'admin.'))
				&& isset(self::$config['admin']['user'])
				&& isset(self::$config['admin']['password'])) {
				self::$configKey = 'admin';
			} else {
				foreach (self::$config['urlPrefix'] ?? [] as $prefix => $v) {
					if (Strings::startsWith(ltrim($requestUri, '/'), $prefix)) {
						self::$configKey = $v;
						break;
					}
				}

				if (self::$configKey === null) {
					self::$configKey = 'default';
				}
			}
		}

		return self::$configKey;
	}
}
