<?php declare(strict_types = 1);

namespace Core\Model\Helpers;

use Core\Model\Entities\ExtraField;
use Core\Model\Helpers\Traits\TExtraField;

abstract class EntityHelpers
{

	/**
	 * @param TExtraField|object $entity
	 * @param mixed|null         $value
	 */
	public static function setExtraField($entity, string $key, $value, ?string $lang = null): ExtraField
	{
		if (!method_exists($entity, 'getExtraFieldsByKey') || !method_exists($entity, 'fillExtraField')) {
			throw new \InvalidArgumentException(get_class($entity) . ' missing TExtraField trait');
		}

		$ef = $entity->getExtraFieldsByKey();

		$result = $ef[$key] ?? null;

		if ($lang && is_array($result)) {
			/** @var ExtraField|null $result */
			$result = $result[$lang] ?? null;
		}

		if (!$result) {
			$result       = new ExtraField($key, (string) $value);
			$result->lang = $lang;
			$entity->fillExtraField($result);
		}

		$result->value = (string) $value;

		return $result;
	}
}
