<?php declare(strict_types = 1);

namespace Core\Model;

use Nette\Utils\DateTime;
use Nette\Utils\FileSystem;
use Tracy\Debugger;

class Logger
{
	/**
	 * @param mixed $message
	 */
	public static function log(string $file, $message): void
	{
		$tmp = explode('/', $file);
		if (count($tmp) > 1) {
			array_pop($tmp);

			FileSystem::createDir(LOG_DIR . DS . implode(DS, $tmp));
		}

		$date = new DateTime;
		$file = str_replace(
			['$Y', '$m', '$d'],
			[$date->format('Y'), $date->format('m'), $date->format('d')],
			$file
		);

		Debugger::log($message, $file);
	}
}
