<?php declare(strict_types = 1);

namespace Core\Model\Mailing;

use Nette\Mail\Mailer;

class MailBuilderFactory
{
	protected Mailer          $mailer;
	protected TemplateFactory $templateFactory;
	public ?string            $siteIdent = null;

	public function __construct(
		Mailer          $mailer,
		TemplateFactory $templateFactory
	)
	{
		$this->mailer          = $mailer;
		$this->templateFactory = $templateFactory;
	}

	public function create(): MailBuilder
	{
		$mail = new MailBuilder($this->mailer);

		if ($this->siteIdent) {
			$mail->setTemplate($this->templateFactory->create($this->siteIdent));
		}

		return $mail;
	}
}
