<?php declare(strict_types = 1);

namespace Core\Model\Navigation;

use Core\Components\Navigation\DaoNavigationItem;
use Core\Model\Dao\SiteMapUrl;
use Core\Model\Helpers\Strings;
use Core\Model\UI\Form\BaseContainer;
use Core\Model\UI\Form\BaseForm;
use Navigations\Model\Providers\INavigationItem;
use Nette\Utils\ArrayHash;

class CustomLink extends BaseNavigation implements INavigationItem
{
	protected $title = 'customLink';

	const TYPE = 'navigation.customLink';

	public function __construct()
	{
	}

	/**
	 * @param BaseForm $baseForm
	 *
	 * @return BaseContainer
	 */
	public function getFormContainer(BaseForm $baseForm)
	{
		$container = new BaseContainer();

		$container->addText('link', 'default.navigationForm.link')
			->setIsMultilanguage();

		return $container;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values)
	{
	}

	/*******************************************************************************************************************
	 * ===========================  Route
	 */

	public function presenterActionCheck($presenter, $action)
	{
		return false;
	}

	/**
	 * @param DaoNavigationItem $params
	 * @param array             $urlParams
	 *
	 * @return array|mixed
	 */
	public function routerIn($params, $urlParams = [])
	{
		return ['remoteLink' => $params->link];
	}

	public function routerOut(DaoNavigationItem $navigation, &$urlParams): ?string
	{
		return $navigation->componentParams['link'][$navigation->getLang()] ?? null;
	}

	/**
	 * @inheritdoc
	 */
	public function getComponentChild(string $lang, $navigation = null, $siteMapData = false)
	{
		$arr = [];

		if (is_string($navigation->link) && Strings::startsWith($navigation->link, 'http')) {
			return $arr;
		}

		$data = [
			'linkPath' => $navigation->link,
			'locale'   => $lang,
		];

		$siteMapUrl = new SiteMapUrl;
		$seo        = [
			'robots'       => 'index, follow',
			'addToSiteMap' => 1,
		];
		$siteMapUrl->setSeo($seo);
		$data['siteMapData']['default'] = $siteMapUrl;

		$arr[] = $data;

		return $arr;
	}
}
