<?php declare(strict_types = 1);

namespace Core\Model\TemplateReader\Providers;

use Nette\Utils\Json;
use Core\Model\TemplateReader\TemplateTextTypesCollection;

class TemplateText
{
	protected TemplateTextTypesCollection $templateTextTypes;

	public function __construct(
		TemplateTextTypesCollection $templateTextTypesCollection
	)
	{
		$this->templateTextTypes = $templateTextTypesCollection;
	}

	/**
	 * @param mixed|null   $value
	 * @param string|array $params
	 *
	 * @return string|array|null
	 */
	public function render(string $type, $value = null, $params = [])
	{
		$item = $this->templateTextTypes->getItemByType($type);

		if ($item) {
			$item->setDefault($value);

			if (is_string($params)) {
				$params = Json::decode($params, Json::FORCE_ARRAY);
			}

			if (isset($params['title'])) {
				$item->setTitle($params['title']);
			}

			if (isset($params['name'])) {
				$item->setName($params['name']);
			}

			return $item->render($params);
		}

		return '';
	}
}
