<?php declare(strict_types = 1);

namespace Core\Model\Templating\Macros;

use Latte\CompileException;
use Latte\Compiler;
use Latte\MacroNode;
use Latte\Macros\MacroSet;
use Latte\PhpWriter;

class Form extends MacroSet
{
	public static function install(Compiler $compiler): void
	{
		$self = new self($compiler);
		$self->addMacro('formContainerControls', [$self, 'macroFormContainerControls']);
	}

	/**
	 * @param MacroNode $node
	 * @param PhpWriter $writer
	 *
	 * @return string
	 * @throws CompileException
	 */
	public function macroFormContainerControls(MacroNode $node, PhpWriter $writer)
	{
		$words = $node->tokenizer->fetchWords();

		if (!$words) {
			throw new CompileException("Missing name in {{$node->name}}.");
		}

		$name = array_shift($words);

		return $writer->write(
			($name[0] === '$'
				? '$tmp = is_object(%0.word) ? %0.word : end($this->global->formsStack)[%0.word];'
				: '$tmp = end($this->global->formsStack)[%0.word];'
			) . 'echo end($this->global->formsStack)->getRenderer()->renderControls($tmp);' . 'unset($tmp);',
			$name
		);
	}
}
