<?php declare(strict_types = 1);

namespace Core\Model\UI\Form\Controls;

use Core\Model\UI\Form\BaseForm;
use Core\Model\UI\Form\Traits\ChoiceInputTrait;
use Core\Model\UI\Form\Traits\InputPromptTrait;
use Core\Model\UI\Form\Traits\TInputExtend;
use Nette\Forms\Controls\SelectBox;
use Nette\Utils\Html;

/**
 * @method BaseForm getForm(bool $throw = true)
 */
class SelectInput extends SelectBox
{
	use ChoiceInputTrait;
	use InputPromptTrait;
	use TInputExtend;

	/**
	 * @param string|object $label
	 */
	public function __construct($label = null, array $items = null)
	{
		parent::__construct($label);

		if (!empty($items)) {
			$this->setItems($items);
		}
	}

	public function isOk(): bool
	{
		return $this->isDisabled()
			|| $this->prompt !== false
			|| $this->getValue() !== null
			|| !$this->options
			|| $this->control->size > 1;
	}

	public function getControl(): Html
	{
		$select = parent::getControl()->setHtml('');

		$select->attrs['class']    = 'form-control form-control-lg';
		$select->attrs['disabled'] = $this->isControlDisabled();

		$options = $this->rawItems;
		if (!empty($this->prompt) && $options) {
			$options = [null => $this->prompt] + $options;
		}

		$select = $this->createTranslatableControl($select);
		$arr    = $this->getIsMultiLanguage() ? $select->getChildren() : [$select];

		$selectedLang = $_COOKIE['contentLang'] ?? 'cs';
		if ($this->getForm(false)) {
			$langs        = $this->getForm(false)->langsService->getLangs(false);
			$defaultLang  = array_key_first($langs);
			if (!array_key_exists($selectedLang, $langs)) {
				$selectedLang = $defaultLang;
			}
		}

		foreach ($arr as $child) {
			$lang    = $child->attrs['data-content-lang'] ?? null;

			if ($lang && $lang !== $selectedLang) {
				$child->attrs['style'] = 'display: none;';
			}

			$optList = $this->makeOptionList($options, function($value) use ($lang) {
				return [
					'selected' => $this->isValueSelected($value, $lang),
					'disabled' => $this->isValueDisabled($value),
				];
			});

			foreach ($optList as $item) {
				$child->addHtml($item);
			}
		}

		return $select;
	}

	/**
	 * @param string|array|int|null $value
	 */
	public function setDefaultValue($value): self
	{
		if ($this->getIsMultiLanguage()) {
			$values = [];

			if (is_array($value)) {
				foreach ($value as $lang => $v) {
					if (array_key_exists($v, $this->getItems())) {
						$values[$lang] = $v;
					}
				}
			}

			parent::setDefaultValue($values);
		} else {
			if (!is_array($value) && array_key_exists($value, $this->getItems())) {
				parent::setDefaultValue($value);
			}
		}

		return $this;
	}
}
