<?php declare(strict_types = 1);

namespace Core\Model\UI\Form\Traits;

use Contributte\ReCaptcha\Forms\InvisibleReCaptchaField;
use Contributte\ReCaptcha\Forms\ReCaptchaField;
use Core\Model\UI\Form\Controls;

/**
 * @method Controls\FilesManagerInput addFilesManager($name, $caption)
 * @method Controls\EditorInput addEditor($name, $caption)
 * @method Controls\LangsSelectInput addLangsSelect($name, $caption)
 * @method Controls\GalleryPopupInput addGalleryPopup($name, $caption)
 * @method InvisibleReCaptchaField addInvisibleReCaptcha(string $name = 'recaptcha', bool $required = true, ?string $message = null)
 * @method ReCaptchaField addReCaptcha(string $name = 'recaptcha', string $label = 'ReCaptcha', bool $required = true, ?string $message = null)
 */
trait BaseContainerTrait
{
	/**
	 * @param string|object|null $label
	 */
	public function addBool(string $name, $label = null, array $items = []): Controls\BoolInput
	{
		$comp = new Controls\BoolInput($label, $items);
		$this->addComponent($comp, $name);

		return $comp;
	}

	/**
	 * @param string|object|null $label
	 */
	public function addDateTimePicker(string $name, $label = null): Controls\DateTimePicker
	{
		$comp = new Controls\DateTimePicker($label);
		$this->addComponent($comp, $name);

		return $comp;
	}

	/**
	 * @param string|object|null $label
	 */
	public function addDatePicker(string $name, $label = null): Controls\DatePicker
	{
		$comp = new Controls\DatePicker($label);
		$this->addComponent($comp, $name);

		return $comp;
	}

	/**
	 * @param string|object|null $label
	 */
	public function addTimePicker(string $name, $label = null): Controls\TimePicker
	{
		$comp = new Controls\TimePicker($label);
		$this->addComponent($comp, $name);

		return $comp;
	}

	public function addTags(string $name, ?string $label = null, ?string $callback = null, ?string $createCallback = null): Controls\TagsInput
	{
		$comp = new Controls\TagsInput($label, $callback, $createCallback);
		$this->addComponent($comp, $name);

		return $comp;
	}

	public function addSortableCheckboxList(string $name, ?string $label = null, array $items = []): Controls\SortableCheckboxList
	{
		$comp = new Controls\SortableCheckboxList($label, $items);
		$this->addComponent($comp, $name);

		return $comp;
	}

	public function addRadioNestedList(string $name, ?string $label = null, array $flatItems = []): Controls\RadioNestedInput
	{
		$comp = new Controls\RadioNestedInput($label, $flatItems);
		$this->addComponent($comp, $name);

		return $comp;
	}

	public function addCheckboxNestedList(string $name, ?string $label = null, array $flatItems = []): Controls\CheckboxListNestedInput
	{
		$comp = new Controls\CheckboxListNestedInput($label, $flatItems);
		$this->addComponent($comp, $name);

		return $comp;
	}

	/**
	 * @param string      $name
	 * @param string|null $saveCaption
	 * @param string|null $saveAndCloseCaption
	 * @param string|null $cancelCaption
	 *
	 * @return Controls\SaveCancelControl
	 */
	public function addSaveCancelControl($name = 'saveControl', $saveCaption = null, $saveAndCloseCaption = null, $cancelCaption = null)
	{
		$comp = new Controls\SaveCancelControl($saveCaption, $saveAndCloseCaption, $cancelCaption);
		$this->addComponent($comp, $name);

		return $comp;
	}

	public function addColorInput(string $name, ?string $label = null): Controls\ColorInput
	{
		$comp = new Controls\ColorInput($label, 255);
		$this->addComponent($comp, $name);

		return $comp;
	}

	public function addWindow(string $name, string $url, ?string $label = null): Controls\Window
	{
		$comp = new Controls\Window($url, $label);
		$this->addComponent($comp, $name);

		return $comp;
	}
}
