<?php declare(strict_types = 1);

namespace Core\Model\UI\Form\Traits;

use Core\Model\UI\Form\Controls\CheckboxListInput;
use Core\Model\UI\Form\Controls\CheckboxListNestedInput;
use Core\Model\UI\Form\Controls\SortableCheckboxList;
use Nette\Forms\Controls\ChoiceControl;
use Nette\Forms\Form;
use Nette\InvalidArgumentException;
use Nette\Utils\Html;

trait ChoiceInputTrait
{
	use ChoiceInputTraitBase;

	public function getValue()
	{
		if ($this->getIsMultiLanguage()) {
			foreach ($this->value as $lang => $val) {
				if (!array_key_exists($val, $this->items))
					$this->value[$lang] = null;
			}

			return $this->value;
		}

		return parent::getValue();
	}
}
