<?php declare(strict_types = 1);

namespace Core\AdminModule\Components\ContentLangSwitcher;

use Core\Model\UI\BaseControl;
use Nette\Http\Request;

/**
 * Class ContentLangSwitcher
 * @package Core\AdminModule\Components\ContentLangSwitcher
 */
class ContentLangSwitcher extends BaseControl
{
	/** @var string */
	public $templateFile = 'Default';

	/** @var string */
	public $title;

	/** @var Request */
	protected $httpRequest;

	public function __construct(Request $request)
	{
		$this->httpRequest = $request;
	}

	public function render()
	{
		$langs = $this->getLangs();

		if (count($langs) === 1)
			return '';

		$this->template->title      = $this->title ?: $this->translator->translate('default.contentLangSwitcher');
		$this->template->activeLang = $this->getActiveLang();
		$this->template->langs      = $langs;
		$this->template->render($this->getTemplateFile($this->templateFile));
	}

	/**
	 * @return string
	 */
	public function getActiveLang() { return $this->httpRequest->getCookie('contentLang', $this->translator->getLocale()); }

	/**
	 * @return array
	 */
	public function getLangs()
	{
		return $this->langsService->getLangs(false);
	}
}
