<?php declare(strict_types = 1);

namespace Core\Model\Templating\Macros;

use Latte\Compiler;
use Latte\MacroNode;
use Latte\Macros\MacroSet;
use Latte\PhpWriter;
use Tracy\Debugger;

final class Macros extends MacroSet
{
	public static function install(Compiler $compiler)
	{
		$self = new self($compiler);
		$self->addMacro('css', [$self, 'macroCss']);
		$self->addMacro('js', [$self, 'macroJs']);
		$self->addMacro('fgc', [$self, 'macroFGC']);
		$self->addMacro('svg', [$self, 'macroSvg']);
	}

	/**
	 * Vloží styly s timestamp
	 *
	 * @param MacroNode $node
	 * @param PhpWriter $writer
	 *
	 * @return string
	 */
	public function macroCss(MacroNode $node, PhpWriter $writer)
	{
		$path = ASSETS_DIR . '/' . $node->args;

		if (!file_exists($path))
			return '';

		$file = str_replace(WWW_DIR, '', ASSETS_DIR) . '/' . $node->args;
		$str  = 'echo \'<link rel="stylesheet" href="' . $file . '?v=' . (Debugger::$productionMode !== false ? filemtime($path) : '\'.filemtime("' . $path . '").\'') . '">\'';

		return $writer->write($str);
	}

	/**
	 * Vloží styly s timestamp
	 *
	 * @param MacroNode $node
	 * @param PhpWriter $writer
	 *
	 * @return string
	 */
	public function macroJs(MacroNode $node, PhpWriter $writer)
	{
		$path = ASSETS_DIR . '/' . $node->args;

		if (!file_exists($path))
			return '';

		$file = str_replace(WWW_DIR, '', ASSETS_DIR) . '/' . $node->args;
		$str  = 'echo \'<script src="' . $file . '?v=' . (Debugger::$productionMode !== false ? filemtime($path) : '\'.filemtime("' . $path . '").\'') . '"></script>\'';

		return $writer->write($str);
	}

	/**
	 * Vloží obsah souboru přes file_get_contents.
	 * Pokud je vložen přímo odkaz na soubor (né proměnná), tak vypíše rovnou obsah.
	 *
	 * @param MacroNode $node
	 * @param PhpWriter $writer
	 *
	 * @return string
	 */
	public function macroFGC(MacroNode $node, PhpWriter $writer)
	{
		$file = trim($node->args, " '");
		if (substr($file, 0, 1) != '$')
			$file = "'$file'";

		//		if (file_exists(WWW_DIR . $file) && Debugger::$productionMode === false) {
		//			$str = 'echo \'' . @file_get_contents(WWW_DIR . $file) . '\'';
		//		} else {
		$str = "echo @file_get_contents(WWW_DIR . " . $file . ')';

		//		}

		return $writer->write($str);
	}

	public function macroSvg(MacroNode $node, PhpWriter $writer)
	{
		$arguments = TemplateText::parseInputAttrs($node->args);
		$pathPrefix = isset($arguments['package']) ? SRC_DIR . '/'. $arguments['package'] . '/assets' : ASSETS_DIR;
		$content = file_get_contents($pathPrefix . '/' . ltrim($arguments['src'],'/'));
		$str = "echo '" . $content . "'";
		return $writer->write($str);

	}
}