<?php declare(strict_types = 1);

namespace Core\Model\UI\Form\Controls;

use Core\Model\UI\Form\Traits\ChoiceInputTrait;
use Core\Model\UI\Form\Traits\InputPromptTrait;
use Core\Model\UI\Form\Traits\TInputExtend;
use Nette\Forms\Controls\SelectBox;
use Nette\Forms\Form;


/**
 * Class SelectInput
 * @package Czubehead\BootstrapForms
 */
class SelectInput extends SelectBox
{
	use ChoiceInputTrait;
	use InputPromptTrait;
	use TInputExtend;

	public function isOk()
	{
		return $this->isDisabled()
			|| $this->prompt !== false
			|| $this->getValue() !== null
			|| !$this->options
			|| $this->control->size > 1;

		return $result;
	}

	/**
	 * SelectInput constructor.
	 *
	 * @param null       $label
	 * @param array|null $items
	 */
	public function __construct($label = null, $items = null)
	{
		parent::__construct($label);

		if (!empty($items))
			$this->setItems($items);
	}

	public function getControl()
	{
		$select = parent::getControl()->setHtml(null);

		$select->attrs += [
			'class'    => 'form-control form-control-lg',
			'disabled' => $this->isControlDisabled(),
		];

		$options = $this->rawItems;
		if (!empty($this->prompt)) {
			$options = [null => $this->prompt] + $options;
		}

		$select = $this->createTranslatableControl($select);
		$arr    = $this->getIsMultiLanguage() ? $select->getChildren() : [$select];

		foreach ($arr as $child) {
			$lang    = $child->attrs['data-content-lang'] ?? null;
			$optList = $this->makeOptionList($options, function($value) use ($lang) {
				return [
					'selected' => $this->isValueSelected($value, $lang),
					'disabled' => $this->isValueDisabled($value),
				];
			});
			foreach ($optList as $item) {
				$child->addHtml($item);
			}
		}

		return $select;
	}

	public function setDefaultValue($value)
	{
		if ($this->getIsMultiLanguage()) {
			$values = [];
			foreach ($value as $lang => $v)
				if (array_key_exists($v, $this->getItems()))
					$values[$lang] = $v;
			parent::setDefaultValue($values);
		} else {
			if (array_key_exists($value, $this->getItems()))
				parent::setDefaultValue($value);
		}

		return $this;
	}
}
