<?php declare(strict_types = 1);

namespace Core\Model\UI\Form\Traits;

use Nette\Utils\Html;


/**
 * Trait BootstrapButtonTrait
 * @package Czubehead\BootstrapForms
 * @property string $btnType
 */
trait BootstrapButtonTrait
{
	/**
	 * @var string
	 */
	private $btnClass = 'btn-primary';

	/**
	 * Gets additional button class. Default is btn-primary.
	 * @return string
	 */
	public function getBtnClass()
	{
		return $this->btnClass;
	}

	/**
	 * Sets additional button class. Default is btn-primary
	 *
	 * @param string $btnClass
	 *
	 * @return static
	 */
	public function setBtnClass($btnClass)
	{
		$this->btnClass = $btnClass;

		return $this;
	}

	public function getControl($caption = null)
	{
		$control = parent::getControl($caption);
		$this->addBtnClass($control);
		$control->setName('button')->addHtml('<span>' . $this->translate($caption === null ? $this->caption : $caption) . '</span>');

		return $control;
	}

	/**
	 * @param Html $element
	 */
	protected function addBtnClass($element)
	{
		$element->class[] = 'btn ' . $this->getBtnClass();
	}
}